#!/usr/bin/env python

#   FILE: pypvm.py -- A wrapper to provide additional functionality to the
#         pypvm module.  Import this instead of importing pypvm directly.
# AUTHOR: W. Michael Petullo, wp0002@drake.edu
#   DATE: 16 MAR 1998
#
# Copyright (c) 1999 W. Michael Petullo
# All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from pypvm_core import *
from pickle import dumps, loads

#PvmDataDefault = 0
#PvmDataRaw     = 1
#PvmDataInPlace = 2

#PvmTaskDefault = 0
#PvmTaskHost    = 1
#PvmTaksArch    = 2
#PvmTaskDebug   = 4
#PvmTaskTrace   = 8
#PvmMppFront    = 16
#PvmHostCompl   = 32

#PvmTaskExit   = 1
#PvmHostDelete = 2
#PvmHostAdd    = 3

#PvmRoute          = 1
#PvmDebugMask      = 2
#PvmAutoErr        = 3
#PvmOutputTid      = 4
#PvmOutputCode     = 5
#PvmTraceTid       = 6
#PvmTraceCode      = 7
#PvmFragSize       = 8
#PvmResvTids       = 9
#PvmSelfOutputTid  = 10
#PvmSelfOutputCode = 11
#PvmSelfTraceTid   = 12
#PvmSelfTraceCode  = 13
#PvmShowTids       = 14
#PvmPollType       = 15
#PvmPollTime       = 16

# ============================ pk () ==========================================
def pk (obj):
#  PRE: obj is assigned a Python object
# POST: obj has been packed into PVM send buffer
	pkstr (dumps (obj))

# ============================ upk () =========================================
def upk ():
# POST: FCTVAL == a Python object read from PVM receive buffer
	return (loads (upkstr ()))
