"""
 setup.py: This is a setup file for Python's Distutils
           installion system.

 Created: November 26, 2002 Sam Tannous
 Adapted: February 2007, Raik Gruenberg

 If you need help, run "python setup.py --help" and
 "python setup.py --help-commands"

 for windows 2k (with Cygwin gcc), you need
 "python setup.py build --compiler=mingw32"

 for all other UNIX building, simply "python setup.py build" will suffice


 this builds various packages

    python setup.py bdist                  tar.gz file
    python setup.py bdist_wininst          win 2k install wizard exe
    python setup.py bdist_dumb             a tar.gz file to be untarred from /
    python setup.py bdist_rpm              two RPMs for Linux

    python setup.py build                  builds everything for an install
    python setup.py install                install everything 
    
 and usually puts RPMS, tgz, exe files in a directory called dist.
 See the Python Distutils web pages for more information on installing
 and other options:
  
    http://www.python.org/doc/current/lib/module-distutils.html

 $Revision: 1.3 $
 $Source: /cvsroot/pypvm/pypvm/setup.py,v $

"""
import sys
import os
from distutils import sysconfig
from distutils.core import setup
from distutils.extension import Extension

prefix = sysconfig.PREFIX

try:
    pvmroot = os.environ['PVM_ROOT']
    pvmarch = os.environ['PVM_ARCH']
except:
    raise Exception, """$PVM_ROOT and/or $PVM_ARCH are not defined.
    You need to install pvm (including shared libraries) and set the PVM_ROOT
    and PVM_ARCH variables before building pypvm.
    See http://biskit.pasteur.fr/install/libraries
    """


inc_dirs = [prefix  + "/include",
            pvmroot + "/include"]

lib_dirs = [prefix  + "/lib",
            prefix  + "/lib64",
            pvmroot + "/lib/" + pvmarch,
            pvmroot + "/pvmgs/" + pvmarch]

libs = ["pvm3","pvmtrc","fpvm3","gpvm3"]

pypvm_extension = Extension(name="pypvm_core",
                            sources = ["pypvm_coremodule.c"],
                            include_dirs = inc_dirs,
                            libraries = libs,
                            library_dirs = lib_dirs)

setup(name="pypvm",
      version="0.95x",
      description="Python Wrapper for PVM",
      author="W. Michael Petullo and Greg Baker",
      author_email="pypvm-discuss@lists.sourceforge.net",
      url="http://pypvm.sourceforge.net/",
      py_modules = ['pypvm'],
      ext_modules = [pypvm_extension]
      )
    

